package w83a.w83aDAO;

import java.sql.CallableStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83a.util.jdbc.W83aDataBase;
import w83a.w83aBeans.W83aDocBean;
import w83a.w83aBeans.W83aHistorialPreavisoBean;
import w83a.w83aBeans.W83aImpugnacionesBean;
import w83a.w83aBeans.W83aPreavisosBean;
import w83a.w83aBeans.W83aTramitePreavisoBean;
import w83a.w83aDAO.w83aConstantesBD.W83aActasBD;
import w83a.w83aDAO.w83aConstantesBD.W83aPreavisosBD;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aDateUtil;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

public class W83aPreavisosDAO implements W83aIPreavisosDAO{
	
	public String insertarHistorialTramitacion(String codSelec,String user)throws Exception {
		String [] codPreaviso=codSelec.split("_");
		CallableStatement cs;
		// Call a procedure with no parameters
	    cs = W83aDataBase.getConnection().prepareCall("{call w83b.w83bHistorialPreavisos(?,?,?,?,?,?,?)}");
	    cs.setInt(1, Integer.parseInt(codPreaviso[2]));//num 
	    cs.setInt(2, Integer.parseInt(codPreaviso[1]));//ao
	    cs.setString(3, codPreaviso[0]);//territorio
	    cs.setString(4, W83aDateUtil.getInstance().getCurrentDateTime(W83aDateUtil.ES_PATTERN_HORA));
	    cs.setString(5, user);
	    cs.setString(6,Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun", "comun.historial.accesopreaviso", W83aClsConstantes.CONSTANTE_CASTELLANO));
	    cs.setString(7,Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun", "comun.historial.accesopreaviso", W83aClsConstantes.CONSTANTE_EUSKARA));
	    cs.execute();
	    return "0";
	}
	
	public W83aPreavisosBean obtenerDatosBasicosPreaviso(String codSelec,String idioma)
	throws Exception {
		String [] codPreaviso=codSelec.split("_");
		
		// TODO Auto-generated method stub
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83aPreavisosBD.num_preaviso_completo).append(", ");
		strSql.append(W83aPreavisosBD.cod_territorio).append(", ");
		strSql.append(W83aPreavisosBD.cod_municipio).append(", ");
		strSql.append(W83aPreavisosBD.codPostal).append(", ");
		strSql.append(W83aPreavisosBD.domicilio).append(", ");
		strSql.append(W83aPreavisosBD.localidad).append(", ");
		strSql.append(W83aPreavisosBD.anyo_eleccion).append(", ");
		strSql.append(W83aPreavisosBD.num_preaviso).append(", ");
		strSql.append(W83aPreavisosBD.numpreavisosencilloentero).append(", ");
		strSql.append(W83aPreavisosBD.fecha_entrada).append(", ");
		strSql.append(W83aPreavisosBD.fecha_inicio).append(", ");
		strSql.append(W83aPreavisosBD.fecha_eleccion).append(", ");
		strSql.append(W83aPreavisosBD.num_registro).append(", ");
		strSql.append(W83aPreavisosBD.fecha_registro).append(", ");
		strSql.append(W83aPreavisosBD.razon_social).append(", ");
		strSql.append(W83aPreavisosBD.id_centrotrabajo).append(", ");
		strSql.append(W83aPreavisosBD.cod_territorio_centro).append(", ");
		strSql.append(W83aPreavisosBD.cif).append(", ");
		strSql.append(W83aPreavisosBD.num_centro).append(", ");
		strSql.append(W83aPreavisosBD.num_trabajadores).append(", ");
		strSql.append(W83aPreavisosBD.eleccion_parcial).append(", ");
		strSql.append(W83aPreavisosBD.preaviso_global).append(", ");
		strSql.append(W83aPreavisosBD.cod_convenio).append(", ");
		strSql.append(W83aPreavisosBD.admon_empresa).append(", ");
		strSql.append(W83aPreavisosBD.num_centros_afectados).append(", ");
		strSql.append(W83aPreavisosBD.num_acta).append(", ");
		strSql.append(W83aPreavisosBD.observaciones).append(", ");
		strSql.append(W83aPreavisosBD.anyo_acta).append(", ");
		strSql.append(W83aPreavisosBD.dirAlternativa).append(", ");
		strSql.append(W83aPreavisosBD.codPostalalternativa).append(", ");
		strSql.append(W83aPreavisosBD.idProvincia_alt).append(", ");
		strSql.append(W83aPreavisosBD.codMunicipio_alt).append(", ");
		strSql.append(W83aPreavisosBD.cods_promotores).append(", ");
		strSql.append(W83aPreavisosBD.tipoPreaviso).append(", ");
		
		if (idioma.equals(W83aClsConstantes.CONSTANTE_CASTELLANO))
		{
			strSql.append(W83aPreavisosBD.desc_promotores).append(" AS ").append(W83aPreavisosBD.desc_promotores).append(", ");
		
		}
		else
		{
			strSql.append(W83aPreavisosBD.dese_promotores).append(" AS ").append(W83aPreavisosBD.desc_promotores).append(", ");
		
		}
		
		strSql.append("'").append(idioma).append("' as IDIOMA");
		
		strSql.append(" FROM w83b.").append(W83aPreavisosBD.preavisosView);
		
		strSql.append(" WHERE ").append(W83aPreavisosBD.cod_territorio).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aPreavisosBD.anyo_eleccion).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aPreavisosBD.num_preaviso).append(" = ?");
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		List listaPreavisos = W83aDataBase.executeQuery(strSql.toString(),params,W83aPreavisosBean.class,null, null);
		((W83aPreavisosBean)listaPreavisos.get(0)).setCodSelec(codSelec);
		return ((W83aPreavisosBean)listaPreavisos.get(0));
	}
	
	public W83aPreavisosBean obtenerRegDefinitivoActaPreaviso(W83aPreavisosBean preaviso)throws Exception {
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83aActasBD.numRegDefinitivo).append(",to_char(");
		strSql.append(W83aActasBD.fecRegDefinitivo);
		strSql.append(",?) as ").append(W83aActasBD.fecRegDefinitivo);
		strSql.append(" FROM ");
		strSql.append(W83aActasBD.actasTable).append(" WHERE ");
		strSql.append(W83aActasBD.numActa).append("=? AND ");
		strSql.append(W83aActasBD.anyoActa).append("=? AND ");
		strSql.append(W83aActasBD.codTerritActa).append("=?");
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(preaviso.getIdioma()));
		params.add(preaviso.getNum_acta());
		params.add(preaviso.getAnyo_acta());
		params.add(preaviso.getCodTerritorio());
		
		List resultado = W83aDataBase.executeQuery(strSql.toString(),params,null);
		
		if(resultado.size()>0){
			Object numReg = ((HashMap)resultado.get(0)).get(W83aActasBD.numRegDefinitivo);
			Object fecReg = ((HashMap)resultado.get(0)).get(W83aActasBD.fecRegDefinitivo);
			
			preaviso.setNumRegDefinitivoActa(numReg==null?"":numReg.toString());
			preaviso.setFechaRegDefinitivoActa(fecReg==null?"":fecReg.toString());
		}
		
	return preaviso;
	}
	
	public W83aPreavisosBean obtenerPreavisoOriginal(String codSelec,String idioma)throws Exception {

		String [] codPreaviso=codSelec.split("_");

		
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83aPreavisosBD.num_preaviso_completo).append(", ");
		strSql.append(W83aPreavisosBD.cod_territorio).append(", ");
		strSql.append(W83aPreavisosBD.anyo_eleccion).append(", ");
		strSql.append(W83aPreavisosBD.num_preaviso).append(", ");
		strSql.append(W83aPreavisosBD.fecha_inicio).append(", ");
		strSql.append(W83aPreavisosBD.fecha_eleccion).append(", ");
		strSql.append(W83aPreavisosBD.razon_social).append(", ");
		strSql.append(W83aPreavisosBD.cif).append(", ");
		strSql.append(W83aPreavisosBD.num_centro).append(", ");
		strSql.append(W83aPreavisosBD.eleccion_parcial).append(", ");
		strSql.append(W83aPreavisosBD.preaviso_global).append(", ");
		strSql.append(W83aPreavisosBD.cod_convenio).append(", ");
		if (idioma.equals(W83aClsConstantes.CONSTANTE_CASTELLANO))
		{
			strSql.append(W83aPreavisosBD.desc_convenio).append(" AS ").append(W83aPreavisosBD.descripcion_convenio).append(", ");

		}
		else
		{
			strSql.append(W83aPreavisosBD.dese_convenio).append(" AS ").append(W83aPreavisosBD.descripcion_convenio).append(", ");

		}
		strSql.append(W83aPreavisosBD.admon_empresa).append(", ");
		strSql.append(W83aPreavisosBD.num_centros_afectados).append(", ");
	
		strSql.append(W83aPreavisosBD.observaciones).append(", ");
		strSql.append(W83aPreavisosBD.dirAlternativa).append(", ");
		strSql.append(W83aPreavisosBD.codPostalalternativa).append(", ");
		strSql.append(W83aPreavisosBD.idProvincia_alt).append(", ");
		strSql.append(W83aPreavisosBD.codMunicipio_alt).append(", ");
		//29082017-> Ampliacin de campos en preaviso original
		strSql.append(W83aPreavisosBD.CNAE).append(", ");
		strSql.append("cnae.DESCCNAE").append(", ");
		strSql.append(W83aPreavisosBD.telefono).append(", ");
		strSql.append(W83aPreavisosBD.fax).append(", ");
		strSql.append(W83aPreavisosBD.email).append(", ");
		strSql.append(W83aPreavisosBD.territsegsocialv02).append(", ");
		strSql.append(W83aPreavisosBD.numsegsocialv02).append(", ");
		strSql.append(W83aPreavisosBD.digitcontsegsocial).append(", ");
		strSql.append(W83aPreavisosBD.numtrabv02).append(", ");
		strSql.append(W83aPreavisosBD.numRegistroES).append(", ");
		strSql.append(W83aPreavisosBD.fechaRegistroES).append(", ");
		
		
		strSql.append(W83aPreavisosBD.cods_promotores).append(", ");
		
		strSql.append("'").append(idioma).append("' as IDIOMA").append(", ");
		if (idioma.equals(W83aClsConstantes.CONSTANTE_CASTELLANO))
		{
			strSql.append(W83aPreavisosBD.desc_promotores).append(" AS ").append(W83aPreavisosBD.desc_promotores);

		}
		else
		{
			strSql.append(W83aPreavisosBD.dese_promotores).append(" AS ").append(W83aPreavisosBD.desc_promotores);

		}

		strSql.append(" FROM w83b.").append(W83aPreavisosBD.preavisosOriginalesView);
		strSql.append(" LEFT OUTER JOIN w83b.w83bcnae cnae ON W83B02V00.CNAE = cnae.idcnae ");
		
		strSql.append(" WHERE ").append(W83aPreavisosBD.cod_territorio).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aPreavisosBD.anyo_eleccion).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aPreavisosBD.num_preaviso).append(" = ?");
		
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		
		List listaPreavisos = W83aDataBase.executeQuery(strSql.toString(),params,W83aPreavisosBean.class,null, null);
		
		if (listaPreavisos.size()>0)
			return (W83aPreavisosBean)listaPreavisos.get(0);
		else
			return new W83aPreavisosBean();
	}
	
	public W83aPreavisosBean obtenerDocsPreaviso(String codSelec,String idioma) throws Exception {
		String [] codPreaviso=codSelec.split("_");

		
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83aPreavisosBD.id_docu_038).append(", ");
		strSql.append(W83aPreavisosBD.nomb_docu_038).append(", ");
		strSql.append(W83aPreavisosBD.c_territ_038).append(", ");
		strSql.append(W83aPreavisosBD.ano_preaviso_038).append(", ");
		strSql.append(W83aPreavisosBD.n_preaviso_038).append(", ");
		strSql.append(W83aPreavisosBD.tp_doc_038).append(", ");
		strSql.append(W83aPreavisosBD.desc_cas_069).append(", ");
		strSql.append(W83aPreavisosBD.desc_eus_069).append(", ");
		strSql.append(W83aPreavisosBD.desc_cas_052).append(", ");
		strSql.append(W83aPreavisosBD.desc_eus_052).append(", ");
		strSql.append(W83aPreavisosBD.desc_cas_012).append(", ");
		strSql.append(W83aPreavisosBD.desc_eus_012).append(", ");
		strSql.append(W83aPreavisosBD.num_reg_038).append(", to_char(");
		strSql.append(W83aPreavisosBD.f_reg_038).append(",?) as ").append(W83aPreavisosBD.f_reg_038).append(", ");
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83aPreavisosBD.usuario_038);

		strSql.append(" FROM w83b.").append(W83aPreavisosBD.preavisos_docsView);
		
		strSql.append(" WHERE ").append(W83aPreavisosBD.c_territ_038).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aPreavisosBD.ano_preaviso_038).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aPreavisosBD.n_preaviso_038).append(" = ?");
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		List listaDocumentos = W83aDataBase.executeQuery(strSql.toString(),params,W83aDocBean.class,null, "preavisos");
		
		W83aPreavisosBean resultado=new W83aPreavisosBean();
		resultado.setListaDocs(listaDocumentos);
		return resultado;

		
	
	}
	
	public W83aPreavisosBean obtenerImpugnacionesPreaviso(String codSelec,String columnaOrder,String tipoOrdenacion,String idioma)
	throws Exception {

		String [] codPreaviso=codSelec.split("_");
		
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		
		strSql.append(W83aPreavisosBD.num_impugnacion_completo).append(", to_char(");
		strSql.append(W83aPreavisosBD.fech_impugnacion).append(",?) as ").append(W83aPreavisosBD.fech_impugnacion).append(", ");
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		if (W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma))
		{
			strSql.append(W83aPreavisosBD.desc_sindicatos).append(" AS DESC_SINDICATOS , ");
		
		}
		else
		{
			strSql.append(W83aPreavisosBD.dese_sindicatos).append(" AS DESC_SINDICATOS, ");
		
		}
		strSql.append(W83aPreavisosBD.dni_arbitro).append(", upper(");
		strSql.append(W83aPreavisosBD.nombre_arbitro).append(") as ").append(W83aPreavisosBD.nombre_arbitro).append(", ");
		strSql.append(W83aPreavisosBD.num_laudo).append(", ");
		strSql.append(W83aPreavisosBD.num_laudocompleto).append(", ");
		strSql.append(W83aPreavisosBD.num_laudocompletoint).append(", ");
		strSql.append(" to_char(");
		strSql.append(W83aPreavisosBD.fech_laudo).append(",?) as ").append(W83aPreavisosBD.fech_laudo).append(", to_char(");
		strSql.append(W83aPreavisosBD.fech_envio_juzgado).append(",?) as ").append(W83aPreavisosBD.fech_envio_juzgado).append(", to_char(");
		strSql.append(W83aPreavisosBD.fech_sentencia).append(",?) as ").append(W83aPreavisosBD.fech_sentencia).append(", to_char(");
		strSql.append(W83aPreavisosBD.fech_baja_desestimiento).append(",?) as ").append(W83aPreavisosBD.fech_baja_desestimiento).append(", ");
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		//strSql.append(W83bPreavisosBD.resultado).append(", ");
		if (W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma))
		{
			strSql.append(W83aPreavisosBD.rdto_cas).append(" AS ").append(W83aPreavisosBD.resultado).append(", ");
			
		}
		else
		{
			strSql.append(W83aPreavisosBD.rdto_eus).append(" AS ").append(W83aPreavisosBD.resultado).append(", ");
			
		}
		
		strSql.append(W83aPreavisosBD.nombreImpugnante).append(", ");
		if (W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma))
		{
			strSql.append(W83aPreavisosBD.desc_tipo).append(" AS ").append(W83aPreavisosBD.desc_tipo);
			
		}
		else
		{
			strSql.append(W83aPreavisosBD.dese_tipo).append(" AS ").append(W83aPreavisosBD.desc_tipo);
			
		}
		
		
		strSql.append(" FROM w83b.").append(W83aPreavisosBD.preaviso_impugnaciones_View);
		
		strSql.append(" WHERE ").append(W83aPreavisosBD.c_territ_nora).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aPreavisosBD.ano_preaviso_037).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aPreavisosBD.n_preaviso_037).append(" = ?");
		
		if(StringUtils.isNotEmpty(columnaOrder)
				&&StringUtils.isNotEmpty(tipoOrdenacion)){
			strSql.append(" ORDER BY ").append(columnaOrder).append(" ").append(tipoOrdenacion);
		}
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		List listaImpugnaciones = W83aDataBase.executeQuery(strSql.toString(),params,W83aImpugnacionesBean.class,null, "");
		
		W83aPreavisosBean resultado=new W83aPreavisosBean();
		resultado.setListaImpugnaciones(listaImpugnaciones);
		return resultado;

	}
	
	public W83aPreavisosBean obtenerHistorialPreaviso(String codSelec,String columnaOrder,String tipoOrdenacion,String strIdioma)
	throws Exception {

		String [] codPreaviso=codSelec.split("_");
		
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		
		strSql.append(W83aPreavisosBD.factu_055).append(", ");
		
		//TODO cambiar a que llegue el idioma
		if(W83aClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			strSql.append(W83aPreavisosBD.desc_cas_055).append(" AS DESCRIPCION , ");
		}else{
			strSql.append(W83aPreavisosBD.dese_cas_055).append(" AS DESCRIPCION , ");			
		}
		
		strSql.append(W83aPreavisosBD.usua_055);
		
		
		strSql.append(" FROM ").append(W83aPreavisosBD.preaviso_historial_Synonym);
		
		strSql.append(" WHERE ").append(W83aPreavisosBD.c_territ_055).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aPreavisosBD.ano_preaviso_055).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aPreavisosBD.n_preaviso_055).append(" = ?");
			
		strSql.append(" ORDER BY ").append(" ").append(W83aPreavisosBD.factu_055).append(" desc ");			
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		List listaHistorial = W83aDataBase.executeQuery(strSql.toString(),params,W83aHistorialPreavisoBean.class,null, strIdioma);
		
		W83aPreavisosBean resultado=new W83aPreavisosBean();
		resultado.setListaHistorial(listaHistorial);
		return resultado;	

}
	
	public W83aPreavisosBean obtenerTramitesPreaviso(String codSelec,String idioma,String columnaOrder,String tipoOrdenacion,String strIdioma)
	throws Exception {
		
		String [] codPreaviso=codSelec.split("_");
		
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		
		strSql.append(W83aPreavisosBD.cod_fase).append(", ");
		if(W83aClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			strSql.append(W83aPreavisosBD.desc_fase).append (" AS DESC_FASE");
		}else{
			strSql.append(W83aPreavisosBD.dese_fase).append (" AS DESC_FASE");			
		}
		strSql.append(", ");
		if(W83aClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			strSql.append(W83aPreavisosBD.desc_tramite).append (" AS DESC_TRAMITE");
		}else{
			strSql.append(W83aPreavisosBD.dese_tramite).append (" AS DESC_TRAMITE");			
		}
		strSql.append(", TO_CHAR(");
		strSql.append(W83aPreavisosBD.f_actu_tramite).append(",?) AS ").append(W83aPreavisosBD.f_actu_tramite).append(",");
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83aPreavisosBD.usu_alta).append(", TO_CHAR(");
		strSql.append(W83aPreavisosBD.fecha_alta_tramite).append(",?) AS ").append(W83aPreavisosBD.fecha_alta_tramite).append(",");
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83aPreavisosBD.usu_mod).append(", TO_CHAR(");
		strSql.append(W83aPreavisosBD.fecha_mod).append(",?) AS ").append(W83aPreavisosBD.fecha_mod).append(", TO_CHAR(");
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83aPreavisosBD.fecha_reg_salida).append(",?) AS ").append(W83aPreavisosBD.fecha_reg_salida).append(", ");
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83aPreavisosBD.num_reg_salid);
		
		
		strSql.append(" FROM ").append(W83aPreavisosBD.vista_historial_tramitacion);
		
		strSql.append(" WHERE ").append(W83aPreavisosBD.cod_territorio).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aPreavisosBD.ano_preaviso).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aPreavisosBD.num_preaviso).append(" = ?");
		
		
		
		strSql.append(" ORDER BY ").append(" ").append(W83aPreavisosBD.cod_tramite).append(" asc ");			
		
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		List listaTramites = W83aDataBase.executeQuery(strSql.toString(),params,W83aTramitePreavisoBean.class,null, null);
			
		W83aPreavisosBean resultado=new W83aPreavisosBean();
		resultado.setListaTramites(listaTramites);
		return resultado;
}
	
public W83aDocBean descargarDocumento(String param) throws Exception {
		
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83aPreavisosBD.nomb_docu_038).append(",");
		strSql.append(W83aPreavisosBD.long_docu_038).append(",");
		strSql.append(W83aPreavisosBD.docu_038);
		strSql.append(" FROM ").append(W83aPreavisosBD.preavisos_docsTable);
		//TODO cambiar por id_doc_037
		strSql.append(" WHERE ").append(W83aPreavisosBD.id_docu_038).append(" = ?");
		
		params.add(param);		
		
		List listaDocumentos = W83aDataBase.executeQuery(strSql.toString(),params,W83aDocBean.class,null, "preavisos");
		
		if (listaDocumentos.size()>0)
			return (W83aDocBean)listaDocumentos.get(0);
		else
			throw new Exception("No existe ese documento");

		

	}
		
}

